/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.lava;

import com.sedmelluq.discord.lavaplayer.natives.ConnectorNativeLibLoader;
import dev.felnull.imp.client.lava.IMPResourceNativeLibraryBinaryProvider;
import dev.felnull.imp.client.lava.IMPSystemNativeLibraryProperties;
import dev.felnull.imp.include.com.sedmelluq.lava.common.natives.NativeLibraryLoader;
import dev.felnull.imp.include.com.sedmelluq.lava.common.natives.architecture.DefaultOperatingSystemTypes;
import dev.felnull.imp.include.com.sedmelluq.lava.common.natives.architecture.SystemType;
import dev.felnull.imp.util.IMPPaths;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LavaPlayerLoader {
    private static final Logger LOGGER = LogManager.getLogger(LavaPlayerLoader.class);
    private static final String LAVA_VERSION = "lava-walkyst-fork-1.3.97";

    public static void init() {
        NativeLibraryLoader[] loaders = null;
        try {
            Field f = ConnectorNativeLibLoader.class.getDeclaredField("loaders");
            f.setAccessible(true);
            loaders = (NativeLibraryLoader[])f.get(null);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to access the native library loader", (Throwable)ex);
        }
        if (loaders == null) {
            return;
        }
        loaders[0] = LavaPlayerLoader.createFiltered(ConnectorNativeLibLoader.class, "libmpg123-0", it -> it.osType == DefaultOperatingSystemTypes.WINDOWS);
        loaders[1] = LavaPlayerLoader.create(ConnectorNativeLibLoader.class, "connector");
    }

    public static NativeLibraryLoader create(Class<?> classLoaderSample, String libraryName) {
        return LavaPlayerLoader.createFiltered(classLoaderSample, libraryName, null);
    }

    public static NativeLibraryLoader createFiltered(Class<?> classLoaderSample, String libraryName, Predicate<SystemType> systemFilter) {
        IMPResourceNativeLibraryBinaryProvider bp = new IMPResourceNativeLibraryBinaryProvider(classLoaderSample);
        return new NativeLibraryLoader(libraryName, systemFilter, new IMPSystemNativeLibraryProperties(libraryName, systemFilter), bp);
    }

    public static Path getNaiveLibraryFolder() {
        return IMPPaths.getNaiveLibraryFolder(LAVA_VERSION);
    }
}

